/*
 * Copyright (c) 2015, Freescale Semiconductor, Inc.
 * Copyright 2016-2017 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef _FSL_FLEXIO_SSI_H_
#define _FSL_FLEXIO_SSI_H_

#include "fsl_common.h"
#include "fsl_flexio.h"

/*!
 * @addtogroup flexio_spi
 * @{
 */

/*******************************************************************************
 * Definitions
 ******************************************************************************/
/*! @brief Define FlexIO SPI access structure typedef. */
typedef struct _flexio_statemachine_type
{
    FLEXIO_Type *flexioBase;     /*!< FlexIO base pointer. */
    uint8_t InputPinIndex;    /*!< Pin select for data input.  n,n+1,n+2 */
    uint8_t shifterIndex[3];     /*!< Shifter index used in FlexIO SPI. */
    uint8_t timerIndex[1];       /*!< Timer index used in FlexIO SPI. */
} FLEXIO_STATEMACHINE_Type;

/*! @brief Define FlexIO SPI master configuration structure. */
typedef struct flexio_statemachine_config
{
    bool enableFlexIO;                        /*!< Enable/disable FlexIO. */
    bool enableInDoze;                        /*!< Enable/disable FlexIO operation in doze mode. */
    bool enableInDebug;                       /*!< Enable/disable FlexIO operation in debug mode. */
    bool enableFastAccess;                    /*!< Enable/disable fast access to FlexIO registers,
                                              fast access requires the FlexIO clock to be at least
                                              twice the frequency of the bus clock. */
} flexio_statemachine_config_t;


/*******************************************************************************
 * API
 ******************************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif /*_cplusplus*/

/*!
 * @name FlexIO SPI Configuration
 * @{
 */


void FLEXIO_StateMachine_Init(FLEXIO_STATEMACHINE_Type *base, flexio_statemachine_config_t *FlexioConfig);
void FLEXIO_StateMachine_InitGetDefaultConfig(flexio_statemachine_config_t *FlexioConfig);


/*@}*/

#if defined(__cplusplus)
}
#endif /*_cplusplus*/
/*@}*/

#endif /*_FSL_FLEXIO_SPI_H_*/
